﻿<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kadry.Forms" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Skrócona lista pracowników etatowych</title>
		<script runat="server">

		//Wspólny kod dla pracownicy - ewidencja, lista skrócona i lista pełna    
    [DefaultWidth(20)]
    public enum Filtr {
        Wszyscy, Pracownicy, PracownicyMłodociani,
    }

    [DefaultWidth(20)]
    public enum Zakres {
        Wszyscy, Przyjęci, Zwolnieni, PrzyjęciIZwolnieni
    }

    public class PrnParams : ContextBase {

        public PrnParams(Context context) : base(context) {
            Date data = ((ActualDate)context[typeof(ActualDate)]).Actual;
            okres = FromTo.Month(data);
        }
        
        Filtr filtr = Filtr.Pracownicy;
        [Priority(1)]
        public Filtr Filtr {
            get { return filtr; }
            set {
                filtr = value;
                OnChanged(EventArgs.Empty);
            }
        }

        Zakres zakres;
        [Priority(2)]
        public Zakres Zakres {
            get { return zakres; }
            set {
                zakres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool przedluzenia = true;
        [Priority(3)]
        [Caption("Uwzgl. przedłużenia")]
        public bool Przedluzenia {
            get { return przedluzenia; }
            set {
                przedluzenia = value;
                OnChanged(EventArgs.Empty);
            }
        }

        FromTo okres;
        [Required]
        [Priority(4)]
        public FromTo Okres {
            get { return okres; }
            set {
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool Test(PracHistoria historia) {
            bool bb = true;
            FromTo zatr;
            switch (Zakres) {
                case Zakres.Przyjęci:
                    zatr = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                    bb &= okres.Contains(zatr.From);
                    break;
                case Zakres.Zwolnieni:
                    zatr = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                    bb &= okres.Contains(zatr.To);
                    break;
                case Zakres.PrzyjęciIZwolnieni:
                    zatr = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                    bool bb1 = okres.Contains(zatr.From);
                    zatr = !Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
                    bool bb2 = okres.Contains(zatr.To);
                    bb &= bb1 | bb2;
                    break;
                case Zakres.Wszyscy:
                    bb &= historia.Pracownik.JestZatrudnionyNaEtat(okres);
                    break;
            }
            switch (Filtr) {
                case Filtr.Pracownicy:
                    bb &= !Młodociany(historia.Etat.RodzajZatrudnienia);
                    break;
                case Filtr.PracownicyMłodociani:
                    bb &= Młodociany(historia.Etat.RodzajZatrudnienia);
                    break;
            }
            return bb;
        }

        static bool Młodociany(RodzajZatrudnienia rodzaj) {
            switch (rodzaj) {
                case RodzajZatrudnienia.Uczeń1Klasy:
                case RodzajZatrudnienia.Uczeń2Klasy:
                case RodzajZatrudnienia.Uczeń3Klasy:
                case RodzajZatrudnienia.MłodocianyPrzyuczany:
                    return true;
                default:
                    return false;
            }
        }
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        //Wyświetlaj kolumnę z informacją którą umową z kolei jest umowa katualna.
        //readonly static bool któraUmowa = true;
        bool ktoraUmowa = true;
        [Priority(1)]
        [Caption("Numer aktualnej umowy")]
        public bool KtoraUmowa {
            get { return ktoraUmowa; }
            set {
                ktoraUmowa = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }		
		                
       PrnParams pars;
       [Context(Required = true)]
       public PrnParams Params {
           set { pars = value; }
       }

       SrParams srpars;
       [SettingsContext]
       public SrParams SrPars {
           get { return srpars; }
           set { srpars = value; }
       }

       class PracHistoriaComparer : IComparer {
           public int Compare(object px, object py) {
               PracHistoria x = (PracHistoria)px;
               PracHistoria y = (PracHistoria)py;
               int result = x.Pracownik.NazwiskoImię.CompareTo(y.Pracownik.NazwiskoImię);
               if (result == 0)
                   result = x.Pracownik.Kod.CompareTo(y.Pracownik.Kod);
               return result;
           }
       }
       
       void OnContextLoad(Object sender, EventArgs args) {
           Wydzial wydz = null;
           bool posr = false;
           if (dc.Context.Contains(typeof(KadryPracownicyViewInfo.PrParams))) {
               KadryPracownicyViewInfo.PrParams param = ((KadryPracownicyViewInfo.PrParams)dc[typeof(KadryPracownicyViewInfo.PrParams)]);
               wydz = param.Wydział;
               posr = param.Pośrednio;
           }
           
           if (!srpars.KtoraUmowa) {
               colUmowa.Visible = false;
               colOd.RowSpan = 2;
           }

           ReportHeader1["OKRES"] = pars.Okres.ToString();

           switch (pars.Zakres) {
               case Zakres.Przyjęci:
                   ReportHeader1["CO"] = "Przyjętych do pracy w okresie";
                   break;
               case Zakres.Zwolnieni:
                   ReportHeader1["CO"] = "Zwolnionych z pracy w okresie";
                   break;
               case Zakres.PrzyjęciIZwolnieni:
                   ReportHeader1["CO"] = "Przyjętych i zwolnionych z pracy w okresie";
                   break;
               default:
                   ReportHeader1["CO"] = "Zatrudnionych w okresie";
                   break;
           }

           switch (pars.Filtr) {
               case Filtr.Pracownicy:
                   ReportHeader1["KTO"] = "pracowników etatowych";
                   break;
               case Filtr.PracownicyMłodociani:
                   ReportHeader1["KTO"] = "pracowników młodocianych";
                   break;
               default:
                   ReportHeader1["KTO"] = "wszystkich pracowników";
                   break;
           }

          Soneta.Business.View v = KadryModule.GetInstance(dc).PracHistorie.WgPracownik.CreateView();
           RowCondition rch = RowCondition.IsIntersected("Aktualnosc", pars.Okres);
           rch &= RowCondition.IsIntersected("Etat.Okres", pars.Okres);
           if (wydz != null) {
               RowCondition rcw = new FieldCondition.Equal("Etat.Wydzial", wydz);
               if (posr)
                   foreach (Wydzial w in wydz.WszystkiePodwydziały)
                       if (w.AccessRight != AccessRights.Denied)
                           rcw |= new FieldCondition.Equal("Etat.Wydzial", w);
               rch &= rcw;
           }
           v.Condition &= rch;
           
           ArrayList result = new ArrayList();
           foreach (PracHistoria ph in v)
                if (pars.Test(ph))
                    Add(result, ph);

           result.Sort(new PracHistoriaComparer());
           Grid1.DataSource = result;
       }

       void Add(ArrayList result, PracHistoria historia) {
           foreach (PracHistoria ph in result) {
               FromTo okresP = !pars.Przedluzenia ? ph.Etat.Okres : ph.Etat.OkresZatrudnienia;
               FromTo okresC = !pars.Przedluzenia ? historia.Etat.Okres : historia.Etat.OkresZatrudnienia;
               if (ph.Pracownik.Guid == historia.Pracownik.Guid && okresP == okresC) {
                   result.Remove(ph);
                   break;
               }
           }
           result.Add(historia);
       }
    
	   int KtóraUmowa(PracHistoria historia) {
			int c = 0;
			bool first = true;
			while (historia!=null && historia.Etat.Okres!=FromTo.Empty) {
				if (first)
					first = false;
				else if (historia.Etat.Okres.To<historia.Aktualnosc.To)
					break;
					
				if (historia.Aktualnosc.Contains(historia.Etat.Okres.From))
					c++;
					
				if (historia.Aktualnosc.From<historia.Etat.Okres.From)
					break;
				
				if (historia.Aktualnosc.From==Date.MinValue)
					historia = null;
				else
					historia = historia.Pracownik[historia.Aktualnosc.From-1];					
			}
			return c;
	   }
	   
       string RodzajZatrudnieniaStr(RodzajZatrudnienia rodzaj) {
           switch (rodzaj) {
               case RodzajZatrudnienia.NieDotyczy:
               case RodzajZatrudnienia.PracownikTymczasowy:
               case RodzajZatrudnienia.PracownikZaGranicą:
               case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                   return "Pracownik";
               case RodzajZatrudnienia.Uczeń1Klasy:
                   return "Uczeń 1 k.";
               case RodzajZatrudnienia.Uczeń2Klasy:
                   return "Uczeń 2 k.";
               case RodzajZatrudnienia.Uczeń3Klasy:
                   return "Uczeń 3 k.";
               case RodzajZatrudnienia.MłodocianyPrzyuczany:
                   return "Prac.młod.";
               case RodzajZatrudnienia.CzłonekRSP:
                   return "Członek RSP";
               case RodzajZatrudnienia.CzłonekSKR:
                   return "Członek SKR";
               case RodzajZatrudnienia.Chałupnik:
                   return "Chałupnik";
               default:
                   return rodzaj.ToString();
           }
       }
    
	void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        PracHistoria ph = (PracHistoria)args.Row;
                
        if (ph.ImieDrugie!="")
			imiona.EditValue = ph.Imie + ", " + ph.ImieDrugie;
        else
			imiona.EditValue = ph.Imie;
    
		uwagi.EditValue = RodzajZatrudnieniaStr(ph.Etat.RodzajZatrudnienia);

		FromTo okres = !pars.Przedluzenia ? ph.Etat.Okres : ph.Etat.OkresZatrudnienia;
		colOd.EditValue = okres.From;
		colDo.EditValue = okres.To;
		
		if (srpars.KtoraUmowa) {
			int c = KtóraUmowa(ph);
			colUmowa.EditValue = c;
		}
    }

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="PracListaSkrócona" method="post" runat="server">
			<EA:DATACONTEXT id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[], Soneta.Business"></EA:DATACONTEXT>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Ewidencja %KTO%|</strong>%CO%: <strong>%OKRES%" runat="server"></cc1:reportheader>
			<EA:GRID id="Grid1" runat="server" RowsInRow="2" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace">
				<Columns>
					<ea:GridColumn RowSpan="2" Caption="LP." DataMember="#" Align="Right" Width="4"></ea:GridColumn>
					<ea:GridColumn id="imiona" Caption="Imiona" Width="22" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Caption="Nazwisko" DataMember="Nazwisko" Width="22" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Caption="PESEL" DataMember="PESEL" Width="13" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Caption="" Width="13" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Caption="Miejsce" DataMember="Adres.Linia1" Width="26"></ea:GridColumn>
					<ea:GridColumn Caption="zamieszkania" DataMember="Adres.Linia2" Width="26" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn id="colOd" Caption="Data przyjęcia do pracy" Width="10"></ea:GridColumn>
					<ea:GridColumn id="colUmowa" Caption="Umowa" Align="Center"></ea:GridColumn>
					<ea:GridColumn id="uwagi" Caption="Uwagi dot." Width="12" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn Caption="pracownika" DataMember="Etat.Wymiar" Width="12" NoWrap="True"></ea:GridColumn>
					<ea:GridColumn id="colDo" RowSpan="2" Caption="Data zwolnienia z pracy" Align="Center" Width="10"
						Format="{0:b}"></ea:GridColumn>
				</Columns>
			</EA:GRID>
			<cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter>
		</form>
	</body>
</HTML>
